/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	edma_init.c
  \brief    	This file Initialize DMA resources. Also configures t
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/17/2008 
  \warning      DMA access is NOT SUPPORTED on CFIFO's and RFIFO's 2 to 5
  * History:
  
*/
/****************************************************************************************/


#include "edma_init.h"


uint32_t cQUEUE0 = 0;      /* CFIFO 0 Queue Variable declaration */
uint16_t rQUEUE0 = 0;      /* RFIFO 0 Queue Variable declaration */

/****************************************************************************************/
/**
 * \brief     This function initialize DMA engine.
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   DMA channel 0 & 1 are always enabled
 */
void vfnedma_init (void)
{

   /* DMA channel 0 assigned to handle transfers to CFIFO 1 register */
   DMAMUX.CHCONFIG[DMA_ADC_CFIFO_CHANNEL].R = (uint8_t)0x80 | (uint8_t)ADC_DMA_CFIFO0_SOURCE;
   /* DMA channel 1 assigned to handle transfers to CFIFO 1 register */
   DMAMUX.CHCONFIG[DMA_ADC_RFIFO_CHANNEL].R = (uint8_t)0x80 | (uint8_t)ADC_DMA_RFIFO0_SOURCE;

/* -------------------------------------------------------------- */
/*             EDMA Configuration Register (DMACR)                */
/* -------------------------------------------------------------- */
    EDMA.CR.R     = 0x00000000;
            /* Bit 30 - Debug is : Disabled                       */
            /* Bit 29 - Channel Arbitration scheme: Fixed Priority*/
            /* Bit 28 - Group Arbitration scheme: Fixed Priority   */
            /* Bit 22~23 - Group 0 priority (GRP0PRI): 0      */
            /* Bit 20~21 - Group 1 priority (GRP1PRI): 1      */
            /* Bit 18~19 - Group 2 priority (GRP2PRI): 2      */
            /* Bit 16~17 - Group 3 priority (GRP3PRI): 3      */
/* DMA Enable Request Registers (DMAERQH,DMAERQL)             */
    EDMA.ERQRL.R   = 0x00000400;  

/* --------------------------------------------------------------  */
/* EDMA Enable Error Interrupt Request Registers (DMAEEIH, DMAEEIL)*/
/* --------------------------------------------------------------  */
    //EDMA.EEIRH.R   = 0x00000000;      /* Register High             */
    EDMA.EEIRL.R   = 0x00000000;      /* Register Low              */

/* -------------------------------------------------------------- */
/* EDMA Channel Priority Register Settings (DCHPRIn) Cha 0 - 63   */
/*                                 Channel  Priority  Pre-emption */
/* -------------------------------------------------------------- */
    EDMA.CPR[0].R   = 0x00;      /*   0,    0,       Disabled   */
    EDMA.CPR[1].R   = 0x01;      /*   1,    1,       Disabled   */
    EDMA.CPR[2].R   = 0x02;      /*   2,    2,       Disabled   */
    EDMA.CPR[3].R   = 0x03;      /*   3,    3,       Disabled   */
    EDMA.CPR[4].R   = 0x04;      /*   4,    4,       Disabled   */
    EDMA.CPR[5].R   = 0x05;      /*   5,    5,       Disabled   */
    EDMA.CPR[6].R   = 0x06;      /*   6,    6,       Disabled   */
    EDMA.CPR[7].R   = 0x07;      /*   7,    7,       Disabled   */
    EDMA.CPR[8].R   = 0x08;      /*   8,    8,       Disabled   */
    EDMA.CPR[9].R   = 0x09;      /*   9,    9,       Disabled   */
    EDMA.CPR[10].R   = 0x0A;     /*   10,    10,       Disabled */
    EDMA.CPR[11].R   = 0x0B;     /*   11,    11,       Disabled */
    EDMA.CPR[12].R   = 0x0C;     /*   12,    12,       Disabled */
    EDMA.CPR[13].R   = 0x0D;     /*   13,    13,       Disabled */
    EDMA.CPR[14].R   = 0x0E;     /*   14,    14,       Disabled */
    EDMA.CPR[15].R   = 0x0F;     /*   15,    15,       Disabled */
 
}

/****************************************************************************************/
/**
 * \brief     This function configures TCD 0 & 1 to handle CFIFOx and RFIFOx
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   DMA channel 0 is assigned to handle CFIFOx and DMA channel 1 \n
 *            handles RFIFOx
 */
 
void vfndma_config_fcn(void)
{
	EDMA.EEIRL.R   = 0x00000000;  // DMA Error Interrupt Enable Register Low (Channels 0-31) : 

/* --------------------------------------------------------------  */
/* Transfer Control Descriptor's for the Eqadc  EDMA Interface      */
/* --------------------------------------------------------------  */
/* -------------------------------------------------------------- */
/*                             TCD 0                             */
/* -------------------------------------------------------------- */
    EDMA.TCD[0].SADDR = (vuint32_t) &cQUEUE0;/* Source Address             */
    EDMA.TCD[0].DADDR = (vuint32_t)CFIFO0_PUSH;            /* Destination Address   EQADC.CFPR[ADC_FIFO_BUFFER].R     */
    EDMA.TCD[0].SMOD  = 0x00;                  /* Source Address Modulo      */
    EDMA.TCD[0].DMOD  = 0x00;                  /* Destination Address Modulo */
    EDMA.TCD[0].SSIZE = 0x02;                  /* Source Transfer Size       */
    EDMA.TCD[0].DSIZE = 0x02;                  /* Destination Transfer Size  */
    EDMA.TCD[0].SOFF  = (vint16_t) 0x0000;       /* Signed Source Addr Offset  */
    EDMA.TCD[0].NBYTES= 0x00000004;            /* Inner "minor" byte count   */
    EDMA.TCD[0].SLAST = (vint32_t)0; /* Last signed Source Address Adjust */
    EDMA.TCD[0].DOFF  = 0x0000;                  /* Signed Destination Address Offset   */
    EDMA.TCD[0].DLAST_SGA = (vint32_t) 0x00000000;   /* Signed Destination Address Adjust     */
    EDMA.TCD[0].BITERE_LINK = 0x00;     
    EDMA.TCD[0].BITER = 0x0001;                 /* Beginning "major" iteration count - Minor Loop Channel Linking Disabled */
    EDMA.TCD[0].CITERE_LINK = 0x00; 	 
    EDMA.TCD[0].CITER = 0x0001; 	         /* Current "major" iteration count - Minor Loop Channel Linking Disabled */
    EDMA.TCD[0].BWC = 0x00;                      /* Bandwidth control: 00000000 */
    EDMA.TCD[0].MAJORLINKCH = 0x00;     /* Major Channel number */
    EDMA.TCD[0].MAJORE_LINK = 0x00;       /* Major Channel Link : Disabled */
    EDMA.TCD[0].DONE = 0x00;                   /* Channel Done */
    EDMA.TCD[0].ACTIVE = 0x00;               /* Channel Active */
    EDMA.TCD[0].E_SG = 0x00;                    /* Enable Scatter/Gather: Disabled */
    EDMA.TCD[0].D_REQ = 0x00;                   /* Disable the DMA channel when Done */
    EDMA.TCD[0].INT_HALF = 0x00;             /* Interrupt on Half Major Count completion:  Disabled */
    EDMA.TCD[0].INT_MAJ = 0x00;               /* Interrupt on major loop completion: Disabled  */
    EDMA.TCD[0].START = 0x00;                 /* Explicit Channel Start bit  */

    
   /* -------------------------------------------------------------- */
   /*                             TCD 1                             */
   /* -------------------------------------------------------------- */
    EDMA.TCD[1].SADDR = (vuint32_t) RFIFO0_POP;/* Source Address   EQADC.RFPR[ADC_FIFO_BUFFER].R          */
    EDMA.TCD[1].DADDR = (vuint32_t) &rQUEUE0;  /* Destination Address        */
    EDMA.TCD[1].SMOD  = 0x00;                  /* Source Address Modulo      */
    EDMA.TCD[1].DMOD  = 0x00;                  /* Destination Address Modulo */
    EDMA.TCD[1].SSIZE = 0x01;                  /* Source Transfer Size       */
    EDMA.TCD[1].DSIZE = 0x01;                  /* Destination Transfer Size  */
    EDMA.TCD[1].SOFF  = (vint16_t) 0x0000;     /* Signed Source Addr Offset  */
    EDMA.TCD[1].NBYTES= 0x00000002;            /* Inner "minor" byte count   */
    EDMA.TCD[1].SLAST = (vint32_t) 0x00000000; /* Last signed Source Address Adjust */
    EDMA.TCD[1].DOFF  = 0x02;                /* Signed Destination Address Offset   */
    EDMA.TCD[1].DLAST_SGA = (vint32_t)-0x02;      /* Signed Destination Address Adjust     */
    EDMA.TCD[1].BITERE_LINK = 0x00;     
    EDMA.TCD[1].BITER = 0x01;                 /* Beginning "major" iteration count - Minor Loop Channel Linking Disabled */
    EDMA.TCD[1].CITERE_LINK = 0x00; 	 
    EDMA.TCD[1].CITER = 0x01; 	         /* Current "major" iteration count - Minor Loop Channel Linking Disabled */
    EDMA.TCD[1].BWC = 0x00;                     /* Bandwidth control: 00000000 */
    EDMA.TCD[1].MAJORLINKCH = 0x00;     /* Major Channel number */
    EDMA.TCD[1].MAJORE_LINK = 0x00;       /* Major Channel Link : Disabled */
    EDMA.TCD[1].DONE = 0x00;                   /* Channel Done */
    EDMA.TCD[1].ACTIVE = 0x00;               /* Channel Active */
    EDMA.TCD[1].E_SG = 0x00;                    /* Enable Scatter/Gather: Disabled */
    EDMA.TCD[1].D_REQ = 0x00;                   /* Disable the DMA channel when Done */
    EDMA.TCD[1].INT_HALF = 0x00;             /* Interrupt on Half Major Count completion:  Disabled */
    EDMA.TCD[1].INT_MAJ = 0x00;               /* Interrupt on major loop completion: Disabled  */
    EDMA.TCD[1].START = 0x00;                 /* Explicit Channel Start bit  */


    EDMA.ERQRL.R   = 0x00000003;              // DMA Enable Request Register Low (Channels 0 and 1) : 

}

/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

